// sn-scriptsync - Received from background script tab via SN Utils.

 /*Run this script to identify the legacy system properties in an insecure state */
(function() {
    properties = [
        {'name':'glide.script.use.sandbox', 'default_getter':'false', 'safe_value':'true'},
        {'name':'glide.ui.ng.authenticate_before_process', 'default_getter':'true', 'safe_value':'true'},
        {'name':'glide.stax.whitelist_enabled', 'default_getter':'false', 'safe_value':'true'},
        {'name':'glide.ui.jelly.js_interpolation.protect', 'default_getter':'false', 'safe_value':'true'},
        {'name':'glide.ui.jelly.js_interpolation.protect_nested_expressions', 'default_getter':'false', 'safe_value':'true'},
        {'name':'glide.stax.allow_entity_resolution', 'default_getter':'true', 'safe_value':'false'},
        {'name':'glide.script.ccsi.ispublic', 'default_getter':'false', 'safe_value':'false'},
        {'name':'glide.security.use_csrf_token', 'default_getter':'false', 'safe_value':'true'},
        {'name':'com.glide.csp.self_script_src_svg', 'default_getter':'false', 'safe_value':'true'},
    ];

    results = {};

    for (i in properties) {
        property = properties[i];

        result = {}
        result['actual_value'] = gs.getProperty(property['name'], '');
        property_value = gs.getProperty(property['name'], property['default_getter']);
        result['assumed_value'] = property_value;

        if (property_value.toLowerCase() != property['safe_value'].toLowerCase()){
            result['at_risk'] = 'true';
            gs.print(property['name']);
        } else {
            result['at_risk'] = 'false';
        }

        results[property['name']] = result;
    }
})();