// JWJ0215 05/05/25	- 	Added and Tested 'israc_report' in RITM section
// Project Insight Update Script
// This script will get needed data from the ServiceNow Project Request (when approved for a project), and 
// push the data to Project Insight.

(function executeRule(current, previous /*null when async*/ ) {
	gs.log("business rule fired");
    var payload = {};

    // get user from user table
    var gr = new GlideRecord("sys_user");
    gr.addQuery("sys_id", current.requested_for);
    gr.query();

    if (gr.next()) {
        payload.requested_for = gr.email.toString();
    }
    // ***End get user***

    // Get Project Insight Records from the project Insight table **U_PROJECT_INSIGHT_RECORDS**
    // get the sys id
    var pigr = new GlideRecord("u_project_insight_records");
    pigr.addQuery("u_requested_item", current.sys_id);
    pigr.query();

    if (pigr.next()) {
        payload.u_project_insight_records_sysid = pigr.sys_id.toString();
        payload.u_project_insight_records_number = pigr.number.toString();
        payload.u_prioritization_group = pigr.u_prioritization_group.toString();
        payload.priority = pigr.priority.getDisplayValue();
        payload.u_expense = pigr.u_expense.toString();
        payload.u_project_request_status = pigr.u_project_request_status.toString();
        payload.short_description = pigr.short_description.toString();
		payload.description = pigr.description.toString();
		payload.u_status = pigr.u_status.toString(); // trying u_status
       
		
    }

		// Grab the Description from the task table ******************************************
	gr = new GlideRecord("task");
    gr.addQuery('description');
    gr.query();

    if (gr.next()) {
        gr.description.toString();
    }



    gr = new GlideRecord("sys_user");
    gr.addQuery("sys_id", current.variables.sponsor_manager_and_up_only_for_this_field);
    gr.query();

    if (gr.next()) {
        payload.sponsor_manager_and_up_only_for_this_field = gr.email.toString();
    }


    gr = new GlideRecord("sys_user");
    gr.addQuery("sys_id", current.variables.contact_name);
    gr.query();

    if (gr.next()) {
        payload.contact_name = gr.name.toString();
    }

    // which_location_is_the_project_for
    gr = new GlideRecord("cmn_department");
    gr.addQuery("sys_id", current.variables.which_location_is_the_project_for);
    gr.query();

    if (gr.next()) {
        payload.cost_center = gr.name.toString();
    }


    // ***End get Project Insight Records***


    // below information is from the **SC_REQ_ITEM** table.
    payload.sys_id = current.sys_id.toString();
	payload.u_project_approved_date = current.u_project_approved_date.toString();
    payload.number = current.number.toString();
	payload.u_project_type = current.u_project_type.toString();
    payload.request_created_on = current.variables.request_created_on.toString();  
    payload.contact_s_phone_number = current.variables.contact_s_phone_number.toString(); 
	payload.what_is_the_problem_you_are_trying_to_solve = current.variables.what_is_the_problem_you_are_trying_to_solve.toString();
	payload.u_estimated_hours = current.u_hours.toString(); 
	payload.u_Is_Archived = current.u_Is_Archived.toString();
	payload.u_Archived_Time = current.u_Archived_Time.toString();
	payload.israc_report = current.u_israc_report.toString();


    var PI = new ProjectInsightScriptInclude();
    var res = PI.send(payload);

})(current, previous);