// JWJ0215 2024
// view aging tickets 2, 3, and 6 months.
ClearUserLog();
u_updateIncidentAging();

function u_updateIncidentAging() {
	var elapsedTime = 0;
	var aging = '';
	var currentTimeNow = gs.nowDateTime();
	var twoMonthsAgoStart = gs.monthsAgoStart(2);
	var threeMonthsAgoStart = gs.monthsAgoStart(3);
	var sixMonthsAgoStart = gs.monthsAgoStart(6);
	
	var gr = new GlideRecord('incident');
	gr.addEncodedQuery('u_aging_category!=>6 Months^ORu_aging_category=');
	gr.setLimit(1000);  // remove set limit  *******************************************************
	gr.query();
	while(gr.next()) {
		elapsedTime = (gs.dateDiff(gr.opened_at, currentTimeNow, true))/60/60/24;
		
		// Calculate days ago and assign aging choice
		if (elapsedTime <= 14) {
			aging = '1-2 Weeks';
		} else if ((elapsedTime > 14) && (elapsedTime <= 28)) {
			aging = '3-4 Weeks';
		} else if ((elapsedTime > 28) && (gr.opened_at >= twoMonthsAgoStart)) {
			aging = '2 Months';
		} else if ((gr.opened_at < twoMonthsAgoStart) && (gr.opened_at >= threeMonthsAgoStart)) {
			aging = '3 Months';
		} else if ((gr.opened_at < threeMonthsAgoStart) && (gr.opened_at >= sixMonthsAgoStart)) {
			aging = '4-6 Months';
		} else if (gr.opened_at < sixMonthsAgoStart) {
			aging = '6 Months';
		}
			
		gr.setWorkflow(false); // Skip any Business Rules
		gr.autoSysFields(false); // Do not update system fields
		gr.u_aging_category = aging;
		//gr.update();   //uncomment to make the update
		UserLog('updated results = ' + gr.number);
	}
}