// JWJ This will disable inactive accounts and send an email to admins of the group is-applications-servicenow
// line 8 sets the time of inactivity. Also, this only finds active users.
disable_users();

function disable_users() {
	ClearUserLog();
    var gr = new GlideRecord("sys_user");
    gr.addQuery('u_last_refreshed', '<', gs.daysAgoStart(1));
    gr.addQuery('active', true);
    gr.addQuery('source', '!=', "");
    gr.query();
    var DeactiveCount = gr.getRowCount();
    gs.log("johntest" +  DeactiveCount);   // uncomment for test
	UserLog("johntest " + DeactiveCount);
    //limit the deactivation to 500 users per day
    if (DeactiveCount <1600) {
        while (gr.next()) {
          gr.active = false;
          gs.log("Disabled inactive user: " + gr.user_name + " – last LDAP update: " + gr.u_last_refreshed);  // comment b4
          //gr.update();    // comment b4 jwj0215
        }
        gs.log("Completed disabling inactive accounts");
    } else {
        var ga = new GlideRecord('sys_user_group');
        ga.addQuery('name', 'IS-Applications-ServiceNow');
        ga.query();
        while (ga.next()) {
            var gadminuser = new GlideRecord("sys_user");
            gadminuser.addQuery("user_name", "admin");
            gadminuser.query();
            while (gadminuser.next()) {
                var cmdbci = new GlideRecord("cmdb_ci");
                cmdbci.addQuery("name", "ServiceNow-PROD");
                cmdbci.query();
                while (cmdbci.next()) {
                    var gi = new GlideRecord("incident");
                    gi.initialize();
                    gi.caller_id = gadminuser.sys_id;
                    gi.short_description = "Error in Scheduled Job: 'Disable Inactive Accounts'";
                    gi.description = "There are more than 500 users discovered to be marked inactive. Please investigate and confirm the LDAP sync is working properly. If there are 500 records either increase the deactivation limit or manually run the script without the limit.";
                    gi.impact = '2';
                    gi.urgency = '2';
                    gi.category = "IS Processes";
                    gi.subcategory = "Operations Center";
                    gi.assignment_group = ga.sys_id;
                    gi.cmdb_ci = cmdbci.sys_id;
                    gi.insert();
                }
            }
        }
    }
}