var PolarisLandingPageTileProvider = Class.create();
PolarisLandingPageTileProvider.prototype = {
    type: 'PolarisLandingPageTileProvider',
    initialize: function() {},
    process: function(request) {
        var tiles = [];
        var tile = {};
		// NOTE: This is just a data provider the consuming "page" must implement the logic to auto-route or provide tiles. A default implementaion of page is provided to handle the auto routing scenario which will either expect the providers to return a single tile OR at least one tile with forceNavigation node filled in.
        // Specify order
        tile.order = 1000;
        // Setting the forceNavigation is telling consumer that you would like to force the navigation without providing options to select the destination to user. Consumer must implement/honor
        var forceNavigation = {};
        tile.forceNavigation = forceNavigation; {
            // How long to wait before navigating the user away
            forceNavigation.navigationDelay = 3000;
            forceNavigation.userGreeting = "Welcome!";
            forceNavigation.navigationMessage = "We'll be landing at your destination shortly.";
        }
        // Data to use for either button or card depending on consumer
        tile.icon = 'clock-outline';
        tile.heading = {
            "label": "Classic",
            "size": "md"
        };
        tile.description = "Go to classic dashboards";
        // The event to emit in case of either forced navigation OR interaction with tile
        tile.event = {
            "name": "NAV_ITEM_SELECTED",
            "payload": {
                "external": {
                    "url": "nav_to.do?uri=%2F$pa_dashboards_overview.do",
                    "target": "_self"
                }
            }
        };
        tiles.push(tiles);
        return tiles;
    }
};