/**
 * @param {params} params
 * @param {api} params.api
 * @param {any} params.event
 * @param {any} params.imports
 * @param {ApiHelpers} params.helpers
 */
function handler({
    api,
    event,
    helpers,
    imports
}) {
    var content = [];
    const { NowDateTime } = imports['sn_uxf.core_libraries']();
    if (api.data.record_information.output && api.data.record_information.output.sourceInfo) {
        if (api.data.record_information.output.sourceInfo.callerInfo.caller.city)
            content.push(api.data.record_information.output.sourceInfo.callerInfo.caller.city);
        var timeZone = api.data.record_information.output.sourceInfo.callerInfo.caller.timeZone;
        var timeZoneValue = api.data.record_information.output.sourceInfo.callerInfo.caller.timeZoneValue;
        var timeFormat = api.context.session.user.timeFormat;
        content.push(NowDateTime().tz(timeZoneValue).format(timeFormat) + ' ' + timeZone);
    }
    var subHeadingList = [];
    if (api.data.record_information.output && api.data.record_information.output.sourceInfo) {
        if (api.data.record_information.output.sourceInfo.callerInfo.caller.title)
            subHeadingList.push(api.data.record_information.output.sourceInfo.callerInfo.caller.title);
        if (api.data.record_information.output.sourceInfo.callerInfo.caller.department)
            subHeadingList.push(api.data.record_information.output.sourceInfo.callerInfo.caller.department);
    }

    api.setState("contactField", [{
            'label': subHeadingList.join(' · ')
        },
        {
            "label": content.join(' · ')
        }
    ]);
}