/**
 * @param {params} params
 * @param {api} params.api
 * @param {any} params.event
 * @param {any} params.imports
 * @param {ApiHelpers} params.helpers
 */
function handler({
    api,
    event,
    helpers,
    imports
}) {
    var mimDuration = api.data.record_information.output.mimDuration;
    if (mimDuration && !mimDuration.increment) {
        api.setState("staticMIMDuration", msToTime(mimDuration.time));
    }
    return;

    function msToTime(duration) {
        if (duration < 1000)
            duration = 0;
        let seconds = Math.floor((duration / 1000) % 60),
            minutes = Math.floor((duration / (1000 * 60)) % 60),
            hours = Math.floor((duration / (1000 * 60 * 60)) % 24),
            days = Math.floor((duration / (1000 * 60 * 60)) / 24);

        hours = ("0" + hours).slice(-2);
        minutes = ("0" + minutes).slice(-2);
        seconds = ("0" + seconds).slice(-2);

        if (days)
            return days + "d " + hours + "hr " + minutes + "min " + seconds + "sec";
        else
            return hours + "hr " + minutes + "min " + seconds + "sec";
    }

}