/**
* @param {params} params
* @param {api} params.api
* @param {any} params.event
* @param {any} params.imports
* @param {ApiHelpers} params.helpers
*/
function handler({api, event, helpers, imports}) {
    if (event.name != "DATA_FETCH_SUCCEEDED" || event.elementId != "retrieve_form_section_layout_1")
        return;

    var sowIncidentOverview = imports['sn_sow_inc.SowIncidentOverview']();

    let fieldsCopy = {
        ...api.context.props.fields
    };
    api.setState("fieldsCopy", fieldsCopy);
    let formSections = sowIncidentOverview.getOverviewFormSections();

    for (let k = 0; k < formSections.length; k++) {
        sowIncidentOverview.processFields(fieldsCopy, formSections[k]);
    }

    const formData = api.data[event.elementId].output.data.GlideViewQuery_Query.uiView.glideLayoutItem._query.GlideLayout_Query;
    const sectionLayout = formData.formLayout.sectionLayout;
    if(!sectionLayout)
        return;
    api.setState('section', {layout: sectionLayout});
    sowIncidentOverview.buildSection(api, sectionLayout, formSections, fieldsCopy);
}