/**
 * @param {params} params
 * @param {api} params.api
 * @param {any} params.event
 * @param {any} params.imports
 * @param {ApiHelpers} params.helpers
 */
async function handler({
    api,
    event,
    helpers,
    imports
}) {
    if (api.context.props.recordTable == 'incident') {
        const slaConfig = api.data.record_information.output.slaConfig;
        if (slaConfig.length > 0) {
            // Set config first because emapty config means: First to breach
            api.setState("slaTimerCfgSysId1", slaConfig[0].configId);
            api.setState("slaTimerCfgSysId2", slaConfig.length > 1 ? slaConfig[1].configId : '');
            api.setState("taskSysId", api.context.props.recordSysId);
        }

        const count = api.data.record_information.output.slaInfo.count;
        api.setState('totalSLAs', count);

        const viewMoreText = api.data.record_information.output.slaInfo.buttonText;
        api.setState('slaViewMoreText', viewMoreText);
        let slaViewMoreBtnARIAProps = {
            "button": {
                "aria-label": viewMoreText
            }
        };
        api.setState('slaViewMoreBtnARIAProps', slaViewMoreBtnARIAProps);
    }
}