//  JWJ 11.17.23
//  POST CLONE Script for specific instance
//define the instance names here
/*
Use this fix script if the theme of DEV INSTANCE is incorrect aftar an upgrade
1. Sets all Colors, 2. Enables Email Notifications, 3. Sets Email Redirection, 4. Disables LDAP Server Config, 5. Sets the Header Name, 6 removes testers from tester group, 7 cancels scheduled reports
8 cancels cmdb schedules, 9 sets cert schedule to on demand, 10 cancels data collection, 11 sets data management, 12 SAM Killer, 13 cancels data collectors, 14 sets ldap ou definitions, 15 ldap servers to active-false, 
16 clears all ecc queues, 17 notifications = false, 18 scheduled jobs active=false, 19 set favicon for instance.
*/
ClearUserLog();
var sandInstance = "thedacaresand";
var prodInstance = "thedacare";
var sandEmailRedirect = "thedacaresand@service-now.com";

//get this instance's name
var thisInstance = gs.getProperty("instance_name");
switch (thisInstance) {
    case sandInstance:
        sandConfig();
        break;
    case prodInstance:
        gs.print("**** You're running this script in production, are you asking for trouble?");
        break;
    default:
        gs.print("**** You are running in the incorrect instance " + thisInstance);
}

function sandConfig() {
    //set colors
    //UserLog("css.base.color", "mediumseagreen"); // replace UserLog with gs.setProperty
	gs.setProperty("css.$nav-highlight-bar-active", "#ffd600");
	gs.setProperty("css.$nav-highlight-bar-inactive", "#ffd600");
	gs.setProperty("css.$nav-hr-color", "#ffd600");
	gs.setProperty("css.$navpage-header-bg", "#80bc00");
	gs.setProperty("css.$navpage-header-color", "#fffff");
	gs.setProperty("css.$navpage-header-divider-color", "#ffd600");
	gs.setProperty("css.$navpage-nav-bg", "#80bc00");
	gs.setProperty("css.$navpage-nav-bg-sub", "#80bc00");
	gs.setProperty("css.$navpage-nav-border", "#ffffff");
	gs.setProperty("css.$navpage-nav-color-sub", "#323e48");
	gs.setProperty("css.$navpage-nav-selected-bg", "#ffd600");
	gs.setProperty("css.$navpage-nav-selected-color", "#80bc00");
	gs.setProperty("css.$navpage-nav-unselected-color", "#ffffff");
	gs.setProperty("css.$subnav-background-color", "#ffd600");
	UserLog('1 Applied SAND Color Configs');

    //enable email notifications  2
    gs.setProperty("glide.email.read.active", true);
	gs.setProperty("glide.email.smtp.active", true);
	UserLog('2 Applied Email Configs');

    // redirect all messages
    gs.setProperty("glide.email.sand.user", sandEmailRedirect);
	UserLog('3 Applied Email redirect');

    //disable all LDAP servers 4
    var ldap = new GlideRecord("ldap_server_config");
    ldap.query();
    while (ldap.next()) {
        active = false;
        ldap.update();
    }
	UserLog('4 Disabled LDAP Server');

    //5 set header name
    gs.setProperty("glide.product.description", "Service Management SAND");
    gs.print("Applied SAND Configurations"); // gs.print
	UserLog('5 Set Header Name Complete');
	
	//6 remove testers from test_impersonator group
	// Query the Group Members [sys_user_grmember] table to find members of the specified group
var groupSysId = '9360165397e886103e1432890353af54'; // test_impersonator group  
var grMember = new GlideRecord('sys_user_grmember');
grMember.addQuery('group', groupSysId);
grMember.query();

// Log the user's Sys ID being removed - for audit purposes 
while (grMember.next()) {
    //UserLog('6 complete - number of users removed is ' + Count); // was gs.info

    // Delete the group member record
    grMember.deleteRecord();}
UserLog('6 complete:  Number of members removed '); // was gs.info
//***************** End ouf remove test users ***************

//************* begin cancel scheduled reports 3 ***************
// 7  Cancel all scheduled reports   ***sysauto_report.LIST***  set to active=false and run_type=5 on_demand
gs.setSession.setStrictQuery(true);
var schedreport = new GlideRecord ('sysauto_report');
schedreport.addEncodedQuery(active=true);
schedreport.query();
//UserLog("found " + schedreport.getRowCount() + " reports to update.");
while (schedreport.next()){
	//UserLog("changing " + schedreport + " records to active-false.");
	schedreport.active = 'false';
	schedreport.update();
}
UserLog('7 cancelled scheduled reports ');
// end **********************************************************

// begin 4 cancel CMDB jobs *************************************
// 8  Cancel all CMDB Schedules     
    //cert_task.LIST   first   state=7 for cancelled
gs.setSession.setStrictQuery(true);
var schedcmdb = new GlideRecord ('cert_task');
schedcmdb.addEncodedQuery(active=true);
schedcmdb.query();
//UserLog("found " + schedcmdb.getRowCount() + " reports to update.");
while (schedcmdb.next()){
	//UserLog("changing " + schedcmdb + " records to active-false.");
	schedcmdb.active = 'false';
	schedcmdb.update();
}
UserLog('8 complete cancelled all cmdb schedules totalling ');
// end of 8 ******************************************************

//begin 9 ********************************************************
//5. cert_schedule.LIST second   run_type=5 on_demand  
gs.setSession.setStrictQuery(true);
var schedcert = new GlideRecord ('cert_schedule');
schedcert.addEncodedQuery('nameISNOTEMPTY^run_type!=on_demand');
schedcert.query();
//UserLog("found " + schedcert.getRowCount() + " reports to update.");
while (schedcert.next()){
	//UserLog("changing " + schedcert + " records to ON Demand.");
	schedcert.run_type = 'on_demand';
	schedcert.update();
}
UserLog('9 complete. set reports to on demand ');
//end of 9 *******************************************************

// begin 10 ********************************************************
// 6.  Cancel all 'Scheduled Data Collection' Jobs     ***sysauto_pa.LIST***    run_type=5 on_demand
gs.setSession.setStrictQuery(true);
var schedreport = new GlideRecord ('sysauto_report');
schedreport.addEncodedQuery(active=true);
schedreport.query();
//UserLog("found " + schedreport.getRowCount() + " reports to update.");
while (schedreport.next()){
	//UserLog("changing " + schedreport + " records to active-false.");
	schedreport.active = 'false';
	schedreport.update();
}
UserLog('10 complete. cancelled scheduled data reports ');
// end 10 **********************************************************

//begin 11 ********************************************************
// 7.  Set all Data Management Tasks to 'Cancelled'...
// JWJ  03.13.24
//UserLog("Starting 'data-management' script", "DATA-MANAGEMENT");
gs.setSession.setStrictQuery(true);
// --use a GlideRecord against the data management table  ****  our variable is 'grcmdbtask'
var grcmdbtask = new GlideRecord('cmdb_data_management_task');
// --create the query
grcmdbtask.addEncodedQuery('state=1^stateNOT IN3,4,7,8');
// --call the query
grcmdbtask.query();
//UserLog("found " + grcmdbtask.getRowCount() + " records to update.", "DATA-MANAGEMENT");
while (grcmdbtask.next()) {
    // --flip the state over
    //UserLog("3. changing: " + grcmdbtask.number + " to CANCELLED.", "DATA-MANAGEMENT");
     //grcmdbtask.getValue('cmdb_data_management_task');
     //grcmdbtask.getValue(grcmdbtask.sys_id);
    //UserLog(grcmdbtask.number);
    grcmdbtask.state = 'cancelled';
    grcmdbtask.update();
}
UserLog("11 completed. ");
//end 11 ************************************************************

// begin 12 ********************************************************
// 8.  Set all SAM jobs to cancelled
//JWJ0215  SAM KILLER sys_trigger
gs.setSession.setStrictQuery(true);
var skreport = new GlideRecord ('sys_trigger');      //name var
skreport.addEncodedQuery("nameLIKESAM -^trigger_typeISNOTEMPTY");     //add encoded filter
skreport.query();
//UserLog("found " + skreport.getRowCount() + " records to update.");     //log messge
while (skreport.next()){     // set while with gr
	//UserLog("changing " + skreport + " records to disabled.");     //log message
	skreport.trigger_type='2';  //set 
	skreport.update();  //update
}
UserLog('12 complete. sam killer ');  //log
// end 12 **********************************************************

//start 13 *********************************************************
//Cancel all Scheduled Data Collectors -Set to On Demand
// JWJ0215 07.02.24
gs.setSession.setStrictQuery(true);
var dcollector = new GlideRecord ('sysauto_pa');
dcollector.addEncodedQuery(active=true);
dcollector.addEncodedQuery(run='On Demand');
dcollector.query();
//UserLog("found " + dcollector.getRowCount() + " data collectors to update.");
while (dcollector.next()){
	//UserLog("changing " + dcollector.sys_name + " records to active=false.");
	dcollector.active = 'false';
	dcollector.run = 'On Demand';
	dcollector.update();
}
UserLog('Data Colectors set to Active=false ');
// end 13 **********************************************************

// begin 14 *******************************************************
//JWJ0215 2024
//10. Set all LDAP OU DEFINITIONS to Active=false
gs.setSession.setStrictQuery(true);
var ldapdef = new GlideRecord ('ldap_ou_config');
ldapdef.addEncodedQuery(active=true);
ldapdef.query();
//UserLog("Found " + ldapdef.getRowCount() + " LDAP Definitions to update.");
while (ldapdef.next()) {
	ldapdef.active = 'false';
	ldapdef.update();
}
UserLog("14 completed. set ldap ou definitions to false ");
// end 14 ***********************************************************

// begin 15 ******************************************************
//JWJ0215 2024
//11. Set all LDAP Server to Active=false
gs.setSession.setStrictQuery(true);
var ldapserv = new GlideRecord ('ldap_server_url');
ldapserv.addEncodedQuery(active=true);
ldapserv.query();
//UserLog("Found " + ldapserv.getRowCount() + " LDAP Server to update.");
while (ldapserv.next()) {
	ldapserv.active = 'false';
	ldapserv.update();
}
UserLog("15 completed. ldap server active=false. ");
// end 15 ********************************************************

// begin 16 ******************************************************
//JWJ0215 2024
//Post upgrade to clear all ECC_Queue tables per KB0547597
//
var ecc = new GlideRecord('ecc_queue');
ecc.deleteMultiple();
//UserLog('16 completed: All ECC_queue tables are clear' + ecc.getRowCount());
UserLog('Post Upgrade 16 Complete ');
// end 16 ***********************************************************

//begin 17 ******************************************************
//JWJ0215 2024
// Make all Email Notifications Active=False
//
gs.setSession.setStrictQuery(true);
var emailact = new GlideRecord ('sysevent_email_action');
emailact.addEncodedQuery(active=true);
emailact.query();
//UserLog("Found " + emailact.getRowCount() + " Email Notifications to update.");
while (emailact.next()) {
	emailact.active = 'false';
	emailact.update();
	//UserLog("17 completed. Email Notifications set to active=false. " + Count);
}
UserLog('Post Upgrade 17 complete ');
// end 17 ********************************************************

//begin 18 ******************************************************
//JWJ0215 2024
// Set all Scheduled Jobs Active=False
//
gs.setSession.setStrictQuery(true);
var schedJobs = new GlideRecord ('sysauto');
schedJobs.addEncodedQuery(active=true);
schedJobs.query();
//UserLog("Found " + schedJobs.getRowCount() + " Scheduled Jobs Active=False");
while (schedJobs.next()) {
	schedJobs.active = 'false';
	schedJobs.update();
}
UserLog('18 Scheduled Jobs Active=False complete ');
// end 18 ********************************************************

//begin 19.  Attempt to set the favicon for the service Portal
//JWJ0215 07.17.24
//
gs.setProperty('glide.product.icon', 'faviconSAND.png');
gs.setProperty('glide.product.icon.icon', 'faviconSAND.png');
gs.setProperty('glide.product.icon.value', 'faviconSAND.png');
UserLog('The DEV favicon has been set to faviconSAND ');
// ***  End 19 ***
}