runMe();

function runMe() {
    var ritmSysId = "";
    var ritmList = [];

    var gr = new GlideRecord("sc_req_item");
    gr.addEncodedQuery("cat_item=3c1644d11b5e4510c4fec913604bcb43^state!=3^active=true");
    gr.query();

    while (gr.next()) {
        ritmSysId = gr.getUniqueValue();

        var scTask = new GlideRecord('sc_task');
        scTask.addEncodedQuery("request_item=" + ritmSysId);
        scTask.addActiveQuery();
        scTask.query();

        //No active task
        if (!scTask.next()) {
            ritmList.push(ritmSysId);
        }
    }

    gs.log("RITM count: " + ritmList.length + "\n\nRITM ids: \n\n" + ritmList.join(","), "AppAccess");

    closeRITM(ritmList);
}

function closeRITM(ritmList) {
    if (gs.nil(ritmList))
        return;

    var gr = new GlideRecord("sc_req_item");
    gr.addEncodedQuery("sys_idIN" + ritmList.toString());
    gr.query();

    while (gr.next()) {
        gr.state = "3";//Closed complete
        gr.stage = "complete";

        if(gr.update()){
			var req = gr.request.getRefRecord();
			
			req.state = "3";//Closed completed
			req.request_state = "closed_complete";
			req.update();
		}
    }
}