//JWJ0215 01.30.25 - Suggest not to load demo data. updated 10.7.25
var loadDemoData = false;
var updateCheck = true; //this can take some time to run and adds a LOT of stuff to the lod making the important bit harder to find

if (updateCheck)
    new sn_appclient.UpdateChecker().checkAvailableUpdates();

var prevName;
var appsArray = [];
var grSSA = new GlideRecord('sys_store_app');
grSSA.addEncodedQuery('install_dateISNOTEMPTY^hide_on_ui=false^vendor=ServiceNow^ORvendorISEMPTY');
grSSA.orderBy('name');
grSSA.orderBy('version');
grSSA.query();
while (grSSA.next()) {
    var curName = grSSA.getValue('name');
    var latestVersion = updateAvailable(grSSA);
    if (curName == prevName) {
        continue;
    }
    if (latestVersion) {
        prevName = curName;
        var appObject = {
            displayName: curName,
            id: grSSA.getUniqueValue(),
            load_demo_data: loadDemoData,
            type: "application",
            requested_version: grSSA.getValue('latest_version')
        };
        appsArray.push(appObject);
    }
}
function updateAvailable(grSSA) {
    var installedVersion = grSSA.getValue('version');
    var latestVersion = grSSA.getValue('latest_version');
    var installedArray = installedVersion.split('.');
	var latestArray = latestVersion.split('.');
	var len = Math.max(installedArray.length, latestArray.length);
	for (var i = 0; i < len; i++) {
		var installed = installedArray[i] ? parseInt(installedArray[i]) : 0;
		var latest = latestArray[i] ? parseInt(latestArray[i]) : 0;
		if (installed < latest) {
			return true;
		} else if (installed > latest) {
			return false;
		}
	}
	return false;
}
if (appsArray.length > 0) {
    var appsPackages = {};
    appsPackages.packages = appsArray;
    appsPackages.name = 'Update Apps';
    var data = new global.JSON().encode(appsPackages);

    var url = 'https://' + gs.getProperty('instance_name') + '.service-now.com/$restapi.do?ns=sn_cicd&service=CICD%20Batch%20Install%20API&version=latest';
    gs.info('Open the following URL in a new tab:\n\n' + url + '\n\ncopy/paste the following JSON into the "Raw" Request body\n\n' + data);
} else {
    gs.info("\n\nNo apps to update found. \n\nIf you think this is incorrect please try running this script again with `updateCheck` set to `true`. This will check the store for any new updates.\n(sometimes there are apps in the Application Manager that say that there are updates but you can't actually update them)\n\n");
}
UserLog('Script has ran-plugins have been updated');
