var SOWListTransformSNC = Class.create();
SOWListTransformSNC.prototype = {
    initialize: function() {},

    transform: function(transformBuilder, transformScriptArgs) {
        if (!transformBuilder) return;
        // Build rowActions object that is passed down as param in editRowActions function
        var rowActionsObj = {
            add: []
        };
        var actionIndex = 1;
        if (gs.hasRole("sn_sow.sow_list") || gs.hasRole("itil")) {
            rowActionsObj['add'].push({
                id: 'copy_url',
                label: sn_i18n.Message.getMessage('sn_sow', 'Copy URL'),
                action: 'LIST#COPY_URL',
                index: actionIndex
            });
            actionIndex++;
        }
        if (gs.hasRole("admin")) {
            rowActionsObj['add'].push({
                id: 'copy_sysId',
                label: sn_i18n.Message.getMessage('sn_sow', 'Copy sys_id'),
                action: 'LIST#COPY_SYSID',
                index: actionIndex
            });
            actionIndex++;
        }
        if (transformBuilder.tableName == "incident" && (gs.hasRole("sn_incident_write") || gs.hasRole("itil"))) {
            rowActionsObj['add'].push({
                id: 'reassign_incident',
                label: sn_i18n.Message.getMessage('sn_sow', 'Reassign'),
                action: 'LIST#REASSIGN_INCIDENT',
                index: actionIndex
            });
            actionIndex++;
        }
        if(transformBuilder.tableName == "incident" && (gs.hasRole("sn_incident_write") || gs.hasRole("itil"))) {
            rowActionsObj['add'].push({
                id: 'assign_to_me_incident',
                label: sn_i18n.Message.getMessage('sn_sow', 'Assign to me'),
                action: 'LIST#ASSIGN_TO_ME_INCIDENT',
                index: actionIndex
            });
            actionIndex++;
        }
        var listModel = transformBuilder

            /* INSTRUCTIONS */
            // The below commented out calls are customizations that can be applied to the list.
            // Uncomment any customizations that you would like to use, and provide your own arguments.
            // We recommend that if possible, you maintain the order the functions are written in, and only use each function once. This prevents accidentally overwriting a customization.
            // Please note note that any operations involving removal or disabling will be executed before operations involving addition or enabling.
            // Keep in mind that any customizations are only for rendering and will not be persisted in any capacity.
            // This script will run on every data fetch, including initial fetch, filtering, sorting, grouping, etc.
            // This API is defined in sys_script_include_a816a0930535a510f8777eba8d465d65, see that file for source code and documentation.

            /* DATA MUTATORS */

            /**
             * Adds new columns and their corresponding body data at a provided index.
             * 
             * @param {Object[]} newColumns Array representing all the columns to be added, index and their respective column data
             * @param {Object} newColumns[].column An object containing the definiton of a single column. Full column docs  - <public url>/now-list/typeSchemas/columnDefinitions/columnsDocs.md
             * @param {number} newColumns[].index The 0-based index at which the column needs to be added. If empty or falsy, the columns is added at the end of the table.
             * @param {Object[]} newColumns[].columnData Array representing all of the columns' cell data to be added and their respective row keys
             * @param {string} newColumns[].columnData.rowKey The key of a row to update
             * @param {Object} newColumns[].columnData.cellValue An object containing the data for a single cell. Full cells docs  - <public url>/now-list/typeSchemas/rowDefinitions/cellsDocs.md
             * TODO: add public urls for docs for columnsDocs and cellDocs
             */
            //.addColumns(newColumns)

            /* COLUMN HEADER MUTATORS */

            /**
             * Changes the label (text) for one or many column header cells
             * 
             * @param {Object[]} newLabels Array representing all the columns to be edited and their respective new labels
             * @param {string} newLabels[].columnKey The key of a column to update
             * @param {string} newLabels[].newLabel The new label to display
             */
            //.editColumnLabels(newLabels)

            /**
             * Toggles the enablement of the column header label click based on the provided edit type for one, many, or all columns.
             * This function can be used to undo the default behavior of sorting a column on header text click.
             * It can also be used to add clickability to a custom added column, for example for a custom sort.
             *
             * @param {Object} editColumnsObj Object containing 'enable' and 'disable' properties.
             * @param {string[]} editColumnsObj.enable Array of column keys for which to enable column header click.
             * @param {string[]} editColumnsObj.disable Array of column keys for which to disable column header click.
             */
            //.toggleColumnHeaderClickEnablement(editColumnsObj)

            /**
             * Sets the column header text click action text for one, many, or all columns.
             *
             * @param {string} text The new text to display in a tooltip on every column that conveys what action clicking triggers. If empty or falsy, all columns will be disabled and will not have a tooltip.
             */
            //.setColumnHeaderClickActionText(newText)

            /**
             * Updates the column header icons based on the provided edit type. 
             *
             * Added icons are purely decorative and not clickable.
             * @param {Object} editIconsObj Object containing 'add' and 'remove' properties.
             * @param {Object[]} editIconsObj.add Array representing all the columns to be edited and their respective inputs for adding icons.
             *   - @param {string} editIconsObj.add[].columnKey The key of a column where column header icons should be added. 
             *       If null, icons will be added to every column.
             *   - @param {'start'|'end'} editIconsObj.add[].position The position to add these icons, relative to the text label. 
             *       Either 'start' or 'end'.
             *   - @param {Object[]} editIconsObj.add[].iconArr Array of objects representing the icons to be added, from start to end.
             *   - @param {string} editIconsObj.add[].iconArr[].value Name of the icon to render from the icon library.
             *   - @param {string} editIconsObj.add[].iconArr[].color Color variant for the icon, e.g., 'warning' or 'moderate'.
             *   - @param {string} editIconsObj.add[].iconArr[].label Aria-label to be used for accessibility.
             * @param {Object[]} editIconsObj.remove Array representing all the icons to be removed and from which columns.
             *   - @param {string} editIconsObj.remove[].columnKey The key of a column where column header icons should be removed. 
             *       If null, icons will be removed from the given position across the table. If position is also null, icons for both positions will be removed.
             *   - @param {'start'|'end'} editIconsObj.remove[].position The existing position of the icon(s) to be removed, relative to the text label. 
             *       Either 'start' or 'end'. If null, icons for the given column will be removed from both positions.
             *   - @param {number[]} editIconsObj.remove[].iconIndexArr Array of 0-based indices of objects representing the icons to be removed. 
             *       If null, all icons will be removed from the given position. If position is also null, all icons for both positions will be removed.
             */
            //.editColumnHeaderIcons(editIconsObj) 


            /**
             * Sets a column's aria-sort value.  This does not actually sort the data, just provides context to screen reader users if the data has already been sorted.
             * 
             * @param {string} columnKey The key of the column that will receive a new sort value. If empty or falsy, all columns will be set to "none" regardless of the value of the direction parameter.
             * @param {'ascending' | 'descending' | 'none'} direction The direction of the sort.
             */
            //.setColumnSortDirection(columnKey, direction) {


            /**
             * Toggles the ability to click on the text in a given column of type URL, link, or person.
             * If you want to toggle this for all columns across the list, we recommend using the boolean property on the controller.
             * 
             * @param {Object} editColumnObj Object containing 'enable' and 'disable' properties.
             * @param {string[]} editColumnObj.enable An array of column keys where clickable text should be enabled. 
             *   If empty or falsy, clickable text will be enabled in all columns.
             * @param {string[]} editColumnObj.disable An array of column keys where clickable text should be disabled. 
             *   If empty or falsy, clickable text will be disabled in all columns.
             */
            //.toggleColumnEnablement(editColumnObj)

            /**
             * Toggles the ability to click on the text in a given cell of type URL, link, or person.
             * The value of disabled at the cell level overrides the value of disabled at the column level.
             *
             * @param {Object} editCellsObj Object containing 'enable' and 'disable' properties.
             * @param {Object[]} editCellsObj.enable Array of objects representing cells where clickable text should be enabled.
             *   - @param {string} editCellsObj.enable[].rowKey The key of the row containing the cell.
             *   - @param {string} editCellsObj.enable[].cellKey The key of the cell.
             * @param {Object[]} editCellsObj.disable Array of objects representing cells where clickable text should be disabled.
             *   - @param {string} editCellsObj.disable[].rowKey The key of the row containing the cell.
             *   - @param {string} editCellsObj.disable[].cellKey The key of the cell.
             */
            //.toggleCellsEnablement(editCellsObj)

            /**
             * Changes the column width for one or many columns
             * This new width will remain in effect until the user manually resizes any column. If the user resizes a column, the manually adjusted width will take precedence.
             * Users can be prevented from resizing a column by setting `columnResizingEnabled` to false. Full doc: <public url>/now-list#public-props
             * 
             * @param {Object[] | string} newWidths Either an array representing all the columns to be edited and their respective new widths, or a string representing the width in px to be set for every column, eg '40px'.
             * @param {string} newLabels[].columnKey The key of a column to update
             * @param {string} newLabels[].newWidth The new width in px
             */
            //.setColumnWidths(newWidths)

            /**
             * Changes the maximum number of characters allowed to be displayed per cell before truncation for one or many columns
             * 
             * @param {Object[]} newMaxChars Either an array representing all the columns to be edited and their respective new maximum.
             * @param {string} newMaxChars[].columnKey The key of a column to update
             * @param {string} newMaxChars[].newMaxChars The new maximum characters in the column
             */
            //.setColumnMaxCharacters(newMaxChars)

            /**
             * Sets highlighted values for cells
             * 
             * @param {Object[]} newHighlightedValues An array representing the highlighted values and the cell they should appear in.
             * @param {string} newHighlightedValues[].rowKey The key of a row containing the cell
             * @param {string} newHighlightedValues[].cellKey The key of a cell to set highlighted value
             * @param {Object} newHighlightedValues[].highlightedValueObj The object containing the highlighted value. Full highlighted value doc - <public url>/now-list/typeSchemas/rowDefinitions/cellsDocs.md#highlighted-value
             * TODO: add public urls for docs for cellDocs
             */
            //.setHighlightedValues(newHighlightedValues)

            /**
             * Sets the display type for a person column: either avatar, name, or both. This function is not applicable to columns that are not the person type.
             * 
             * @param {Object[]} newDisplays An array representing the columns to update and their new display setting.
             * @param {string} newDisplays[].columnKey The key of a column to update.
             * @param {'avatar'|'name'|'both'} newDisplays[].newDisplay Sets the appearance of body cells in this column. Can be 'avatar', 'name', or 'both'.
             */
            //.changeDisplayForPersonColumn(newDisplays)

            /**
             * Sets the numActionIcons property to determine the number of actions to render as icons. 
             * The first n items in the actionItems array will be rendered as icon buttons, and the rest will be hidden under a dropdown.
             * 
             * @param {number} numActionIcons Number of actions to render as icons
             */
            .setRowActionCountOverflow(1)

            /**
             * Updates the row actions for all rows based on the provided edit type.
             *
             * @param {Object} editActionsObj Object containing 'add' and 'remove' properties.
             * @param {Object[]} editActionsObj.add Array of objects representing the row actions to be added.
             *   - @param {string} editActionsObj.add[].id A unique string identifier for this action
             *   - @param {string} editActionsObj.add[].icon A now-icon name to represent this action
             *   - @param {string} editActionsObj.add[].label The label to be displayed in tooltips and dropdowns
             *   - @param {string} editActionsObj.add[].action The name of a Seismic action to dispatch
             *   - @param {number} editActionsObj.add[].index The index at which to insert the action. If null or falsy, the action will be added to the end of the array.
             * @param {string[]} editActionsObj.remove An array of ID strings representing all the row actions to be removed. 
             *   If empty or falsy, all the row actions will be removed
             */
            .editRowActions(rowActionsObj)

            /**
             * Toggles enablement/disablement one or many row actions on a row by row basis. Any disabled actions will be visible but not interactable.
             * 
             * @param {Object} editActionsObj An array of objects representing the row actions to be toggled.
             * @param {Object[]} editActionsObj[].disable An array of objects representing the row actions to be disabled. The specified action will be visible but not interactable.
             *   - @param {string} editActionsObj[].disable.rowKey The key of the row to update
             *   - @param {string[]} editActionsObj[].disable.actionIds An array of action keys that represent actions to disable.
             */
            //.toggleRowActionsEnablement(editActionsObj)

            /**
             * Updates the column header actions based on the provided edit type.
             * If all actions are removed through this function, the default column filtering popover will display on the list.
             *
             * @param {Object} editColumnActionsObj Object containing 'add' and 'remove' properties.
             * @param {Object[]} editColumnActionsObj.add Array of objects representing the column and its respective column header actions to be added.
             *   - @param {string} editColumnActionsObj.add[].columnKey The key of the column to update
             *   - @param {Object[]} editColumnActionsObj.add[].actionObjArr The action object to be added
             *     - @param {string} editColumnActionsObj.add[].actionObjArr[].id The id of the action to be added
             *     - @param {string} editColumnActionsObj.add[].actionObjArr[].label The label of the action to be added
             *     - @param {string} editColumnActionsObj.add[].actionObjArr[].action The name of a Seismic action to dispatch on click
             *     - @param {number} editColumnActionsObj.add[].actionObjArr[].index The index at which to insert the action. If null or falsy, the action will be added to the end of the array.
             * @param {Object[]} editColumnActionsObj.remove Array of objects representing the column and its respective column header actions to be removed.
             *   - @param {string} editColumnActionsObj.remove[].columnKey The key of the column to update
             *   - @param {string[]} editColumnActionsObj.remove[].actionIdArr The IDs of actions to be removed
             */
            //.editColumnHeaderActions(editActionsObj)

            /**
             * Updates the cell actions across a whole column based on the provided edit type.
             * This can be used to remove the default 'Show matching' and 'Filter out' actions, but we recommend using the controller prop if you want to remove both.
             *
             * @param {Object} editActionsObj Object containing 'add' and 'remove' properties.
             * @param {Object[]} editActionsObj.add Array of objects representing the column and its respective cell actions to be added.
             *   - @param {string} editActionsObj.add[].columnKey The key of the column to update
             *   - @param {Object[]} editActionsObj.add[].actionObjArr The action object to be added
             *     - @param {string} editActionsObj.add[].actionObjArr[].id The id of the action to be added
             *     - @param {string} editActionsObj.add[].actionObjArr[].label The label of the action to be added
             *     - @param {string} editActionsObj.add[].actionObjArr[].action The name of a Seismic action to dispatch on click
             *     - @param {number} editActionsObj.add[].actionObjArr[].index The index at which to insert the action. If null or falsy, the action will be added to the end of the array.
             * @param {Object[]} editActionsObj.remove Array of objects representing the column and its respective cell actions to be removed.
             *   - @param {string} editActionsObj.remove[].columnKey The key of the column to update. If empty or falsy, removes all cell actions across the list.
             *   - @param {string[]} editActionsObj.remove[].actionIdArr The IDs of actions to be removed. If empty or falsy, removes all the cell actions on the column.
             */
            //.editCellActionsForColumn(editActionsObj)

            /**
             * Updates the override cell actions based on the provided edit type.
             * If there are no actions present in this override, the cell actions defined at the column level will be used instead.
             *
             * @param {Object} editActionsObj Object containing 'add' and 'remove' properties.
             * @param {Object[]} editActionsObj.add Array of objects representing the cell and its respective cell actions to be added.
             *   - @param {string} editActionsObj.add[].rowKey The key of the row to update
             *   - @param {string} editActionsObj.add[].cellKey The key of the cell to update
             *   - @param {Object[]} editActionsObj.add[].actionObjArr The action object to be added
             *     - @param {string} editActionsObj.add[].actionObjArr[].id The id of the action to be added
             *     - @param {string} editActionsObj.add[].actionObjArr[].label The label of the action to be added
             *     - @param {string} editActionsObj.add[].actionObjArr[].action The seismic action to dispatch from the new action
             *     - @param {number} editActionsObj.add[].actionObjArr[].index The index at which to insert the action. If null or falsy, the action will be added to the end of the array.
             * @param {Object[]} editActionsObj.remove Array of objects representing the cell and its respective cell actions to be removed.
             *   - @param {string} editActionsObj.remove[].rowKey The key of the row to update
             *   - @param {string} editActionsObj.remove[].cellKey The key of the cell to update
             *   - @param {string[]} editActionsObj.remove[].actionIdArr The action ids to be removed
             */
            //.editOverrideCellActions(editActionsObj)

            /**
             * Sets the expanded state of one or more groups
             * 
             * @param {Object[]} groupObjectArr An array of objects representing the group and its respective expanded state
             * @param {string} groupObjectArr[].groupKey The key of the group to update
             * @param {boolean} groupObjectArr[].isExpanded The expanded state of the group
             */
            //.setGroupsExpandedState(groupObjectArr)

            /**
             * Updates the group actions based on the provided edit type.
             *
             * @param {Object} editActionsObj Object containing 'add' and 'remove' properties.
             * @param {Object[]} editActionsObj.add Array of objects representing the group and its respective actions to be added.
             *   - @param {string} editActionsObj.add[].groupKey The key of the group to update
             *   - @param {Object[]} editActionsObj.add[].actionObjArr The action object to be added
             *     - @param {string} editActionsObj.add[].actionObjArr[].id The id of the action to be added
             *     - @param {string} editActionsObj.add[].actionObjArr[].label The label of the action to be added
             *     - @param {string} editActionsObj.add[].actionObjArr[].action The name of a Seismic action to dispatch on click
             *     - @param {number} editActionsObj.add[].actionObjArr[].index The index at which to insert the action. If null or falsy, the action will be added to the end of the array.
             * @param {Object[]} editActionsObj.remove Array of objects representing the group and its respective actions to be removed.
             *   - @param {string} editActionsObj.remove[].groupKey The key of the group to update. If null or falsy, the actions will be removed from all groups.
             *   - @param {string[]} editActionsObj.remove[].actionIdArr The IDs of actions to be removed. If null or falsy, all the actions will be removed from the given group.
             */
            //.editGroupActions(editActionsObj)

            /**
             * Hides declarative actions that require record selection
             */
            //.hideDAsRequiringSelection()

            // do not remove
            .transform();


        // You can make further changes to columnDefinitions and rowDefinitions objects here
        // to customize the experience of the list
        // TODO: add public urls for docs for rowDefinitions and columnDefinitions
        // Full rowDefinitions docs  - <public url>/now-list/typeSchemas/rowDefinitions/rowDefinitionsDocs.md
        // Full columnDefinitions docs - <public url>/now-list/typeSchemas/columnDefinitions/columnDefinitionsDocs.md

        //	eg. loop thru columns and set column properties
        //	listModel.columnDefinitions.columns.forEach(function(column) {
        //		// add end icon to short description column
        //		if(column.key === 'short_description') {
        //			column.icons = {
        //				endIcons: [{ value: 'camera-fill', color: 'positive', label: 'aria label' }]
        //			};
        //		}
        //		// and starting icon to state column
        //		if(column.key === 'state') {
        //			column.icons = {
        //				startIcons: [{ value: 'eye-outline', color: 'critical', label: 'aria label' }]
        //			};
        //		}
        //		// add custom cell action in priority column
        //		if(column.key === 'priority') {
        //			if(!column.cellActions) column.cellActions = [];
        //			column.cellActions.push({
        //				id: 'custom_action',
        //				label: 'Do Cell Action',
        //				action: 'CUSTOM_COMPONENT#CUSTOM_CELL_CLICK',
        //			});
        //		}
        //	});

        //	eg. loop thru rows and make changes to row based properties
        //	listModel.rowDefinitions.rows.forEach(function(row, index) {
        //		// disable row selection on every other row
        //		if(index % 2 === 0) {
        //			row.selectionDisabled = true;
        //		}
        //	});

        return listModel;
    },

    type: 'SOWListTransformSNC'
};