var SOWPolarisLandingPageTileProvider_Default = Class.create();
SOWPolarisLandingPageTileProvider_Default.prototype = {
    type: 'SOWPolarisLandingPageTileProvider_Default',
    initialize: function() {},
    _getTile: function(order, navigationDelay, userGreeting, navigationMessage, icon, heading, description, url) {
        var forceNavigationNode = {
            navigationDelay: navigationDelay,
            navigationMessage: navigationMessage
        };
        // forceNavigationNode.userGreeting = userGreeting;
        return {
            order: order,
            forceNavigation: forceNavigationNode,
            icon: icon,
            heading: {
                label: heading,
                size: 'md'
            },
            description: description,
            event: {
                name: 'NAV_ITEM_SELECTED',
                payload: {
                    external: {
                        url: url,
                        target: '_self'
                    }
                }
            }
        };
    },
    process: function(request) {

        // Constants
        var ORDER = 1000;
        var DELAY = 1000;
        var NAV_GREETING = gs.getMessage('Welcome {0}', gs.getUser().getDisplayName());
        var NAV_MSG = gs.getMessage('We\'ll be landing at your destination shortly...');
        var ICON = null;

        // Tiles
        var items = [];

        var sowHeading = gs.getMessage('Service Operations Workspace');
        var sowDescription = gs.getMessage('Go to Service Operations Workspace');
        var sowUrl = '/now/sow';
        var sowTile = this._getTile(ORDER, DELAY, NAV_GREETING, NAV_MSG, ICON, sowHeading, sowDescription, sowUrl);
        items.push(sowTile);

        return items;
    }
};