var SOWPolarisLandingPageTileService = Class.create();
SOWPolarisLandingPageTileService.prototype = {
    type: 'SOWPolarisLandingPageTileService',
    initialize: function() {},
    process: function(request) {
        var response = {};
        var errors = {};
        var status = {};
        var items = [];
        var count = -1; // No extensions processed
        var extensions = new GlideScriptedExtensionPoint().getExtensions("sn_sow.PolarisLandingPageTileProvider");
        if (extensions.length > 0) {
            count = 0;
            for (var i = 0; i < extensions.length; i++) {
                var extension = extensions[i];
                var extensionStatus = {};
                var extensionId = extension.type;
                status[extensionId] = extensionStatus;
                var startTime = Date.now();
                try {
                    var subItems = extension.process(request);
                    for (var j in subItems) {
                        // Generate id to help with unique lookup
                        subItems[j].id = gs.generateGUID();
                        subItems[j].provider = extensionId;
                        items[count++] = subItems[j];
                    }
                } catch (e) {
                    try {
                        extensionStatus.error = JSON.stringify(e);
                    } catch (e) {
                        extensionStatus.error = "Unknown error";
                    }
                }
                var executionTime = Date.now() - startTime;
                extensionStatus.runtime = executionTime;
            }
            items.sort(function(a, b) {
                if (a && b) {
                    var aOrder = a.order ? a.order : 0;
                    var bOrder = b.order ? b.order : 0;
                    return aOrder - bOrder;
                }
                return 0;
            });
        }
        response.count = count;
        response.tiles = items;
        response.providers = status;
        return response;
    }
};