/**
 * @param {params} params
 * @param {api} params.api
 * @param {any} params.event
 * @param {any} params.imports
 * @param {ApiHelpers} params.helpers
 */
function handler({
    api,
    event,
    helpers,
    imports
}) {
    const eventName = event.name;
    const {
        displayValue,
        fieldName,
        value
    } = event.payload;
    let { elementId } = event;
    let formSection = elementId.substring(0, elementId.indexOf('_'));
    var sowIncidentOverview = imports['sn_sow_inc.SowIncidentOverview']();
    const getObjectIndex = (obj, name) => {
        const len = obj.length;
        if (len == 0) {
            return -1;
        }
        return obj.findIndex((ele) => ele.name == name);
    };
    
    switch (eventName) {
        case 'NOW_RECORD_FORM_SECTION_COLUMN_LAYOUT#SET_VALUE':
            var tempChanges = api.state.serializedChanges ? JSON.parse(api.state.serializedChanges) : [];
            var newFieldObj = api.state.fieldsCopy[fieldName];
            const index = getObjectIndex(tempChanges, fieldName);
            if (index == -1) {
                tempChanges.push({
                    newFieldObj,
                    value,
                    displayValue
                });
            } else {
                tempChanges[index] = {
                    newFieldObj,
                    value,
                    displayValue,
                };
            }
            api.setState('serializedChanges', JSON.stringify(tempChanges));
            sowIncidentOverview.onFieldChange(api, helpers, api.state.fieldsCopy, fieldName, value, displayValue);
            var dirtyFields = api.state.dirtyFields;
            if(dirtyFields[formSection]) {
                dirtyFields[formSection].push(fieldName);
            } else {
                dirtyFields[formSection] = [fieldName];
            }
            api.setState("dirtyFields",dirtyFields);
            break;
    }
}