/**
* @param {params} params
* @param {api} params.api
* @param {any} params.event
* @param {any} params.imports
* @param {ApiHelpers} params.helpers
*/
function handler({api, event, helpers, imports}) {
    if (!api.data[event.elementId].output || !api.data[event.elementId].output.change_request)
        return;

    const containers = { ...api.state.hideAllContainers };
    const result = api.data[event.elementId].output;

    const changeState = result.change_request.state.value;
    if (changeState)
        api.setState('changeState', changeState);

    const cards = { ...result.cards };
    if (cards) {
        const cardIds = Object.keys(cards);
        if (cardIds)
            cardIds.map(id => { containers[id].hide = false; });
    }

    // Hide containers if the data they show is empty

    if (!result.cabMeeting || !result.cabMeeting.hasMeeting)
        containers.cab.hide = true;

    if (!result.riskActions.changeRiskDetails || !result.riskActions.changeRiskDetails.sysId)
        containers.risk.hide = true;

    if (!result.changeDateInfo || result.changeDateInfo &&
        !(result.changeDateInfo.plannedHasValue || result.changeDateInfo.actualHasValue))
        containers.dates.hide = true;

    api.setState('containers', containers);
}